import UIKit

class ViewController: UIViewController, UIScrollViewDelegate
{
    @IBOutlet weak var myScrollView: UIScrollView!
    var imagesArr : Array<String>!
    
    override func viewDidLoad()
    {
        super.viewDidLoad()
        self.loadImages()
        
        myScrollView.layoutIfNeeded()
        myScrollView.delegate = self
        
        var origX: CGFloat = 0.0
        var newFrameWidth : CGFloat = 0.0
        
        let ourHeight : CGFloat = myScrollView.bounds.height
        
        for eachImg in imagesArr
        {
            let image = UIImage (named: eachImg)
            let thisImgView = UIImageView(image: image)
            
            let oldWidth = thisImgView.bounds.width
            let oldHeight = thisImgView.bounds.height
            
            let heightRatio = ourHeight / oldHeight
            newFrameWidth = oldWidth * heightRatio
            
            let newFrame = CGRect(x: origX,
                                  y: 0.0,
                                  width: newFrameWidth,
                                  height: ourHeight)
            thisImgView.frame = newFrame
            myScrollView.addSubview(thisImgView)
            
            origX += newFrameWidth
            thisImgView.contentMode = UIView.ContentMode.scaleAspectFill
        }
        
        myScrollView.contentSize = CGSize(width: origX,
                                          height: ourHeight)

    }
    
    func scrollViewDidScroll(_ scrollView: UIScrollView)
    {
        scrollView.contentOffset.y = 0.0
    }

    
    func loadImages()
    {
        imagesArr = [
            "137646854.jpg",
            "485745110-612x612.jpg",
            "15311623965b43af1cbf5012.58969934.jpg",
            "flower.jpg",
            "gettyimages-705351545.jpg",
            "image-editing-101040_1280.jpg",
            "img_lights.jpg",
            "opportunities-pics-of-an-owl-barred-national-geographic-768x768.jpg",
            "Reverse-Image-Search-Engines-Apps-And-Its-Uses-2016.jpg"
        ]
    }

}

